VERSION ("WLAN Demo 1.0")

'****************************************************************************
'
'Demo Program for 8360 (Bluetooth) and 8370 (802.11b)
'
'****************************************************************************

	GOSUB SysInit
LOOP:
	GOSUB MainInput
	GOTO LOOP

'----------------------------------------------------------------------------
'System Initialization
'----------------------------------------------------------------------------
SysInit:
	IntConn        = 0			'A number of connection wish
						'to be opened
	IntUpdate      = 0
	StrServerIPA$  = ""			'Remote IP
	StrServerIPB$  = ""
	StrServerIPC$  = ""
	StrServerIPD$  = ""
	StrServerPort$ = ""			'Remote Port

	RETURN

'============================================================================
MainPage:
	CLS
	CURSOR (0)
	ALPHA_LOCK (2)

	SELECT_FONT (1)
	SET_VIDEO_MODE (0)
	LOCATE 1, 1
	StrIPAddress$ = SOCKET_IP (-1)
	PRINT "IP: " + StrIPAddress$

	SELECT_FONT (2)
	LOCATE 4, 1
	IF IntSelection = 1 THEN		'Take data
		SET_VIDEO_MODE (1)
	END IF
	PRINT "1. Take data   "
	SET_VIDEO_MODE (0)
	IF IntSelection = 2 THEN
		SET_VIDEO_MODE (1)
	END IF					'Configure
	LOCATE 6, 1
	PRINT "2. Configure   "
	SET_VIDEO_MODE (0)

	GOSUB ShowDateTime
	RETURN

'----------------------------------------------------------------------------
MainInput:
	CLR_KBD
	OFF ALL
	DISABLE READER (1)

	IntSelection =  1
	GOSUB MainPage

	IntMainFlag = 1
	WHILE IntMainFlag = 1
		StrKeyData$ = ""
		StrKeyData$ = INKEY$

		IF StrKeyData$ <> "" THEN
			IntKeyData = ASC (StrKeyData$)

			'Up-arrow or Down-arrow
			IF  IntKeyData = 140 OR IntKeyData = 141 THEN
				IF IntSelection = 1 THEN
					IntSelection = 2
				ELSE
					IntSelection = 1
				END IF
			ELSE IF IntKeyData = 13 THEN		'Enter
				IF IntSelection = 1 THEN
					GOSUB TakeDataInput
					IntSelection = 1
				ELSE
					GOSUB ConfigureInput
					IntSelection = 2
				END IF
			ELSE IF IntKeyData = 49 THEN		'1
				GOSUB TakeDataInput
				IntSelection = 1
			ELSE IF IntKeyData = 50 THEN		'2
				GOSUB ConfigureInput
				IntSelection = 2
			END IF
			GOSUB MainPage
		ELSE
			GOSUB ShowDateTime
		END IF

		WAIT (25)
	WEND

	RETURN

'============================================================================
TakeDataPage:
	CLS
	CURSOR (0)

	SELECT_FONT (2)
	SET_VIDEO_MODE (0)

	LOCATE 2, 1
	StrIPAddress$ = SOCKET_IP (-1)			'Get local IP
	PRINT StrIPAddress$
	LOCATE 4, 1
	PRINT "Item:" + StrItem$				'Show Item
	LOCATE 6, 1
	PRINT "Name:" + StrName$				'Show Name
	LOCATE 8, 1
	PRINT "Qty :" + StrQty$				'Show Qty

	LOCATE IntCurY, IntCurX
	CURSOR (1)

	RETURN

'----------------------------------------------------------------------------
TakeDataInput:
	CLR_KBD
	ON READER (1) GOSUB GetReaderData
	DISABLE READER (1)

	IntSocketOld = -1
	GOSUB InitConnectInput				'Initialize TCP/IP
	IF IntInitConnFlag = 2 THEN

		GOSUB OpenNet				'Connection
		IF IntOpenNetFlag = 2 THEN

			IntTakeDataFlag = 1
			WHILE IntTakeDataFlag = 1
				StrItem$ = ""
				StrName$ = ""
				StrQty$  = ""
				IntCurY  = 4
				IntCurX  = 6
				ENABLE READER (1)

				IntInputDataFlag = 1
				WHILE IntInputDataFlag = 1
					IntSocket = SOCKET_OPEN (IntConn)		'Check on-line or not
					IF IntSocket <> IntSocketOld THEN
						IF IntSocket = 0 THEN
							GOSUB TakeDataPage
						ELSE
							CURSOR (0)
							LOCATE 2, 1
							PRINT "No connection  "
						END IF
						IntSocketOld = IntSocket
					END IF

					IF IntSocket = 0 AND SOCKET_HAS_DATA (IntConn) = 0 THEN
						IntSec& = 0
						StrData$ = NREAD (IntConn)
						GOSUB ProcessData
						GOSUB TakeDataPage
					END IF

					StrKeyData$ = ""
					StrKeyData$ = INKEY$
					IF StrKeyData$ <> "" THEN
						IntKeyData = ASC (StrKeyData$)

						IF IntKeyData = 27 THEN		'ESC key
							IntInputDataFlag = 0
							IntTakeDataFlag  = 0
						ELSE IF IntSocket = 0 THEN
							IF  IntKeyData = 140 THEN				'Up-arrow
								IF IntCurY = 8 THEN
									StrName$ = ""
									StrQty$ = ""
									IntCurY = 4
									IntCurX = LEN (StrItem$) + 6
									ENABLE READER (1)
								END IF
							ELSE IF IntKeyData = 13 THEN			'Enter
								IF IntCurX < 13 AND IntCurY = 4 THEN
									GOSUB QueryItem
									DISABLE READER (1)
								ELSE IF IntCurX > 6 AND IntCurY = 8 THEN
									GOSUB UpdateItem
									IntInputDataFlag = 0
								END IF
							ELSE IF IntKeyData = 8 THEN				'BS key
								IF IntCurY = 4 THEN		'Item
									IntLen = LEN (StrItem$)
									IF IntLen > 0 THEN
										IntCurX = IntLen - 1 + 6
										StrItem$ = LEFT$ (StrItem$, IntLen - 1)
									END IF
								ELSE				'Qty
									IntLen = LEN (StrQty$)
									IF IntLen > 0 THEN
										IntCurX = IntLen - 1 + 6
										StrQty$ = LEFT$ (StrQty$, IntLen - 1)
									END IF
								END IF
							ELSE IF IntKeyData = 1 THEN				'Clear key
								IF IntCurY = 4 THEN		'Item
									StrItem$ = ""
								ELSE				'Qty
									StrQty$  = ""
								END IF
								IntCurX = 6
							ELSE IF IntKeyData >= 48 AND IntKeyData <= 57 THEN
								'Qty input
								IF IntCurY = 8 THEN
									IntLen = LEN (StrQty$)
									IF IntLen > 9 THEN			'Length <= 9
										IntLen  = IntLen - 1
										StrQty$ = LEFT$ (StrQty$, IntLen -1)
									END IF
									StrQty$ = StrQty$ + StrKeyData$
									ntCurX  = IntLen + 1 + 6
								'Item input
								ELSE IF IntCurY = 4 THEN
									IntLen = LEN (StrItem$)
									IF IntLen > 13 THEN			'Length <= 13
										IntLen   = IntLen - 1
										StrItem$ = LEFT$ (StrItem$, IntLen -1)
									END IF
									StrItem$ = StrItem$ + StrKeyData$
									IntCurX  = IntLen + 1 + 6
								END IF
							END IF
						GOSUB TakeDataPage
						END IF
					END IF
				WAIT (25)
				WEND
			WEND
		END IF
	END IF

	NCLOSE (IntConn)
	STOP TCPIP
	RETURN

'----------------------------------------------------------------------------
InitConnectPage:
	CLS
	CURSOR (0)
	SELECT_FONT (2)
	SET_VIDEO_MODE (0)

	LOCATE 2, 1
    	PRINT "Initializing..."
	LOCATE 4, 1
    	PRINT "Please wait!   "

	RETURN

'----------------------------------------------------------------------------
InitConnectInput:
	GOSUB InitConnectPage
	START TCPIP						'Initialize TCP/IP

	IntInitConnFlag = 1
	WHILE IntInitConnFlag = 1
		IntWlanState = GET_WLAN_STATUS (7)
		IF IntWlanState = 1 THEN			'To get the connection status = "Ready"
			IntInitConnFlag = 2
		ELSE
			StrKeyData$ = ""
			StrKeyData$ = INKEY$
			IF StrKeyData$ <> "" THEN
				IntKeyData = ASC (StrKeyData$)
				IF IntKeyData = 27 THEN
					IntInitConnFlag = 0
				END IF
			END IF

		END IF
		WAIT (25)
	WEND

	RETURN

'----------------------------------------------------------------------------
ConfigurePage:						'Configure menu
	CLS
	CURSOR (0)

	SELECT_FONT (1)
	SET_VIDEO_MODE (0)

	LOCATE 1, 1
	PRINT "=== WLAN Setting ==="

	LOCATE 2, 1
	IF IntSelection = 1 THEN
		SET_VIDEO_MODE (1)
	END IF
	PRINT "1. Subnet Mask      "
	SET_VIDEO_MODE (0)

	LOCATE 3, 1
	IF IntSelection = 2 THEN
		SET_VIDEO_MODE (1)
	END IF
	PRINT "2. Local IP Address "
	SET_VIDEO_MODE (0)

	LOCATE 4, 1
	IF IntSelection = 3 THEN
		SET_VIDEO_MODE (1)
	END IF
	PRINT "3. Default Gateway  "
	SET_VIDEO_MODE (0)

	LOCATE 5, 1
	IF IntSelection = 4 THEN
		SET_VIDEO_MODE (1)
	END IF
	PRINT "4. DNS Server       "
	SET_VIDEO_MODE (0)

	LOCATE 6, 1
	IF IntSelection = 5 THEN
		SET_VIDEO_MODE (1)
	END IF
	PRINT "5. SSID     "
	SET_VIDEO_MODE (0)

	LOCATE 7, 1
	IF IntSelection = 6 THEN
		SET_VIDEO_MODE (1)
	END IF
	PRINT "6. Server IP"
	SET_VIDEO_MODE (0)

	LOCATE 8, 1
	IF IntSelection = 7 THEN
		SET_VIDEO_MODE (1)
	END IF
	PRINT "7. Server Port      "
	SET_VIDEO_MODE (0)

	RETURN

'----------------------------------------------------------------------------
ConfigureInput:
	CLR_KBD

	IntSelection = 1
	GOSUB ConfigurePage

	IntConfigureFlag = 1
	WHILE IntConfigureFlag = 1
		StrKeyData$ = ""
		StrKeyData$ = INKEY$

		IF StrKeyData$ <> "" THEN
			IntKeyData = ASC (StrKeyData$)

			IF IntKeyData = 27 THEN			'ESC
				IntConfigureFlag = 0
			ELSE IF IntKeyData = 140 THEN		'Up-arrow
				IF IntSelection > 1 THEN
					IntSelection = IntSelection - 1
				ELSE
					IntSelection = 7
				END IF
				GOSUB ConfigurePage
			ELSE IF IntKeyData = 141 THEN		'Down-arrow
				IF IntSelection < 7 THEN
					IntSelection = IntSelection + 1
				ELSE
					IntSelection = 1
				END IF
				GOSUB ConfigurePage
			ELSE IF IntKeyData = 13 THEN		'Enter
				GOSUB WLANSettingsInput
				GOSUB ConfigurePage
			'1 ~ 7
			ELSE IF IntKeyData >= 49 AND IntKeyData <= 55 THEN
				IntSelection = IntKeyData - 48

				IF IntSelection = 5 THEN
					ALPHA_LOCK (0)
				END IF

				GOSUB WLANSettingsInput
				GOSUB ConfigurePage
			END IF
		END IF

		WAIT (25)
	WEND

	RETURN

'============================================================================
WLANSettingsPage:
	CLS
	CURSOR (0)

	SELECT_FONT (1)
	SET_VIDEO_MODE (0)

	LOCATE 2, 1
	PRINT " Current :  "
	LOCATE 4, 1
	PRINT " New :      "
	LOCATE 7, 1
	PRINT "[ Enter ] to select "
	LOCATE 8, 1
	PRINT "[  ESC  ] to cancel "

	LOCATE 1, 1
	IF IntSelection = 1 THEN
		PRINT "    SubNet Mask     "
		StrCurrentSets$ = SOCKET_IP (-2)
	ELSE IF IntSelection = 2 THEN
		PRINT "  Local IP Address  "
		StrCurrentSets$ = SOCKET_IP (-1)
	ELSE IF IntSelection = 3 THEN
		PRINT "   Default Gateway  "
		StrCurrentSets$ = SOCKET_IP (-3)
	ELSE IF IntSelection = 4 THEN
		PRINT "     DNS Server     "
		StrCurrentSets$ = SOCKET_IP (-4)
	ELSE IF IntSelection = 5 THEN
		PRINT "SSID"
		StrCurrentSets$ = SOCKET_IP (-6)
	ELSE IF IntSelection = 6 THEN
		PRINT "     Server IP      "
		IF StrServerIPA$ = "" THEN
			StrCurrentSets$ = ""
		ELSE
			StrCurrentSets$ = StrServerIPA$ + "." + StrServerIPB$ + "." + StrServerIPC$ + "." + StrServerIPD$
		END IF
	ELSE
		PRINT "    Server Port     "
		StrCurrentSets$ = StrServerPort$
	END IF

	LOCATE 3, 5
	PRINT StrCurrentSets$
	LOCATE 5, 5
	PRINT StrNewSets$
	CURSOR (1)
	IntLen = LEN (StrNewSets$)
	LOCATE 5, IntLen+5

	RETURN

'----------------------------------------------------------------------------
WLANSettingsInput:
	CLR_KBD
	StrCurrentSets$ = ""
	StrNewSets$     = ""
	StrTempIP$      = ""
	StrTempIPA$     = ""
	StrTempIPB$     = ""
	StrTempIPC$     = ""
	StrTempIPD$     = ""
	StrTempPort$    = ""

	IntCurX = 0

	GOSUB WLANSettingsPage

	IntWLANSettingsFlag = 1
	WHILE IntWLANSettingsFlag = 1
		StrKeyData$ = ""
		StrKeyData$ = INKEY$

		IF StrKeyData$ <> "" THEN
			IntKeyData = ASC (StrKeyData$)

			IF IntKeyData = 27 THEN			'ESC
				IntWLANSettingsFlag = 0
			ELSE IF IntKeyData = 13 THEN		'Enter
				GOSUB IsPass
				GOSUB ShowMessage
				IF IntResult = 1 THEN
					GOSUB SaveData
					IntWLANSettingsFlag = 0
				ELSE
					GOSUB WLANSettingsPage
				END IF
			ELSE IF IntKeyData = 8 THEN		'BS
				GOSUB BackSpace
				GOSUB WLANSettingsPage
			ELSE IF IntKeyData = 1 THEN		'Clear
				StrNewSets$ = ""
				IF IntSelection <= 4 OR IntSelection = 6 THEN
					IntCurX = 0
					StrTempIP$  = ""
					StrTempIPA$ = ""
					StrTempIPB$ = ""
					StrTempIPC$ = ""
					StrTempIPD$ = ""
				ELSE IF IntSelection = 7 THEN
					StrTempPort$ = ""
				END IF
				GOSUB WLANSettingsPage
			ELSE
				GOSUB InputProcess
			END IF
		END IF

		WAIT (25)
	WEND

	RETURN

'----------------------------------------------------------------------------
InputProcess:
	IF IntSelection <= 4 OR IntSelection = 6 THEN		'IP
		'0 ~ 9
		IF IntKeyData >= 48 AND IntKeyData <= 57 THEN
			StrTempIP$ = StrTempIP$ + StrKeyData$
			GOSUB CheckIPAddress
			GOSUB ShowMessage
			GOSUB WLANSettingsPage
		'"."
		ELSE IF IntKeyData = 46 THEN
			GOSUB CheckDot
		END IF
	ELSE IF IntSelection = 5 THEN				'SSID
		'" " ~ "~"
		IF IntKeyData >= 32 AND IntKeyData <= 127 THEN
			IntLen = LEN (StrNewSets$)
			IF IntLen < 15 THEN
				StrNewSets$ = StrNewSets$ + StrKeyData$
			END IF
			GOSUB WLANSettingsPage
		END IF
	ELSE							'Port
		IF IntKeyData >= 48 AND IntKeyData <= 57 THEN
			StrNewSets$ = StrNewSets$ + StrKeyData$
			GOSUB CheckIPPort
			GOSUB ShowMessage
			GOSUB WLANSettingsPage
		END IF
	END IF

	RETURN

'============================================================================
ShowDateTime:
	SELECT_FONT (1)

	IntTimerSec = TIMER
	IntTimerSec = IntTimerSec MOD 2

	StrDateTime$ = DATE$			'Get date
	StrMonth$    = MID$ (StrDateTime$, 5, 2)

	IF StrMonth$ = "01" THEN		'Month: number->abbreviation
		StrShowTime$ = "JAN "
	ELSE IF StrMonth$ = "02" THEN
		StrShowTime$ = "FEB "
	ELSE IF StrMonth$ = "03" THEN
		StrShowTime$ = "MAR "
	ELSE IF StrMonth$ = "04" THEN
		StrShowTime$ = "APR "
	ELSE IF StrMonth$ = "05" THEN
		StrShowTime$ = "MAY "
	ELSE IF StrMonth$ = "06" THEN
		StrShowTime$ = "JUN "
	ELSE IF StrMonth$ = "07" THEN
		StrShowTime$ = "JUL "
	ELSE IF StrMonth$ = "08" THEN
		StrShowTime$ = "AUG "
	ELSE IF StrMonth$ = "09" THEN
		StrShowTime$ = "SEP "
	ELSE IF StrMonth$ = "10" THEN
		StrShowTime$ = "OCT "
	ELSE IF StrMonth$ = "11" THEN
		StrShowTime$ = "NOV "
	ELSE
		StrShowTime$ = "DEC "
	END IF

	StrShowTime$ = StrShowTime$ + RIGHT$ (StrDateTime$, 2) + ", " + LEFT$ (StrDateTime$, 4)

	IF IntTimerSec = 0 THEN
		StrDelimiter$ = ":"
	ELSE
		StrDelimiter$ = " "
	END IF

	StrDateTime$ = TIME$			'Get time
	StrShowTime$ = StrShowTime$ + "  " + LEFT$ (StrDateTime$, 2) + StrDelimiter$ + MID$ (StrDateTime$, 3, 2)

	LOCATE 8, 1
	PRINT  StrShowTime$

	RETURN

'----------------------------------------------------------------------------
OpenNet:
	CURSOR (0)
	ALPHA_LOCK (2)

	SELECT_FONT (2)
	LOCATE 2, 1
	PRINT "No connection  "

	IntOpenNetFlag = 1
	IF StrServerIPA$ <> "" AND StrServerPort$ <> "" THEN
		StrServerIP$ = StrServerIPA$ + "." + StrServerIPB$ + "." + StrServerIPC$ + "." + StrServerIPD$
		TCP_OPEN (IntConn, StrServerIP$, VAL (StrServerPort$), 0)

		IntTcpipFlag = 1
		IntTimeOut = TIMER + 20
		WHILE IntTcpipFlag = 1
			IntNow = TIMER

			IF IntNow > IntTimeOut THEN
				IntTcpipFlag = 0
			END IF

			IntMsg = GET_TCPIP_MESSAGE
			IF IntMsg = 4080 THEN
				BEEP (1600, 10)
				StrItem$  = ""
				StrName$  = ""
				StrQty$   = ""

				IntCurY   = 4
				IntCurX   = 6
				IntSocket = 0
				IntOpenNetFlag = 2
'				GOSUB TakeDataPage
				IntTcpipFlag = 0
			END IF

			StrKeyData$ = ""
			StrKeyData$ = INKEY$
			IF StrKeyData$ <> "" THEN
				IntKeyData = ASC (StrKeyData$)
				IF IntKeyData = 27 THEN
					IntTcpipFlag = 0
				END IF
			END IF

		WAIT (25)
		WEND
	ELSE
		LOCATE 2, 1
		PRINT "Invalid IP or  "
		LOCATE 4, 1
    		PRINT "port number!!  "
		WAIT (100)
	END IF

	RETURN

'----------------------------------------------------------------------------
ProcessData:
	StrChar$ = LEFT$ (StrData$, 1)
	IF StrChar$ = "D" THEN
		BEEP (1600, 5)
		IntUpdate = 1
		IntTemp   = INSTR (StrData$, ",")
		IntLen    = LEN (StrData$)
		StrName$  = MID$ (StrData$, 2, IntTemp-2)
		StrQty$   = MID$ (StrData$, IntTemp+1, IntLen - IntTemp)

		LOCATE 6, 6
		PRINT StrName$
		LOCATE 8, 6
		PRINT StrQty$

		IntCurX = LEN (StrQty$) + 6
		IntCurY = 8
		CURSOR (1)
		LOCATE IntCurY, IntCurX

	ELSE IF StrChar$ = "N" THEN
		StrName$ = "**********"
		StrQty$  = ""

		IntCurX = LEN (StrQty$) + 6
		IntCurY = 8
		CURSOR (1)
		LOCATE IntCurY, IntCurX

	ELSE IF StrChar$ = "U" THEN
		BEEP (3000, 10, 0, 5, 3000, 10)
	END IF

	RETURN

'----------------------------------------------------------------------------
QueryItem:
	CURSOR (0)
	DISABLE READER (1)
	IntUpdate = 0
	StrData$ = "I"
	StrData$ = StrData$ + StrItem$
	NWRITE (IntConn, StrData$)
	RETURN

'----------------------------------------------------------------------------
UpdateItem:
	StrData$ = "Q"
	StrData$ = StrData$ + StrItem$ + "," + StrQty$
	NWRITE (IntConn, StrData$)

	RETURN

'----------------------------------------------------------------------------
CheckIPAddress:
	IntLen = LEN (StrTempIP$)
	IntVal = VAL (StrTempIP$)

	IF IntLen < 4 AND IntVal >= 0 AND  IntVal <= 255 THEN
		GOSUB CopyDataTo
		IntResult = 0
	ELSE
		StrTempIP$ = LEFT$ (StrTempIP$, IntLen-1)
		IntResult = -2
	END IF

	GOSUB CombineString

	RETURN

'----------------------------------------------------------------------------
CombineString:
	IF IntCurX = 0 THEN
		StrNewSets$ = StrTempIPA$
	ELSE IF IntCurX = 1 THEN
		StrNewSets$ = StrTempIPA$ + "." + StrTempIPB$
	ELSE IF IntCurX = 2 THEN
		StrNewSets$ = StrTempIPA$ + "." + StrTempIPB$ + "." + StrTempIPC$
	ELSE
		StrNewSets$ = StrTempIPA$ + "." + StrTempIPB$ + "." + StrTempIPC$ + "." + StrTempIPD$
	END IF

	RETURN

'----------------------------------------------------------------------------
CheckIPPort:
	IntLen  = LEN (StrNewSets$)
	IntVal& = VAL (StrNewSets$)

	IF IntLen < 6 AND IntVal& >= 0 AND  IntVal& <= 65535 THEN
		StrTempPort$ = StrNewSets$
		IntResult    = 0
	ELSE
		StrNewSets$ = StrTempPort$
		IntResult   = -4
	END IF

	RETURN

'----------------------------------------------------------------------------
CheckDot:
	IF IntCurX = 0 AND StrTempIPA$ <> "" THEN
		IntVal = VAL (StrTempIPA$)
	ELSE IF IntCurX = 1 AND StrTempIPB$ <> "" THEN
		IntVal = VAL (StrTempIPB$)
	ELSE IF IntCurX = 2 AND StrTempIPC$ <> "" THEN
		IntVal = VAL (StrTempIPC$)
	ELSE
		IntVal = -1
	END IF

	IF IntVal >= 0 AND IntVal <= 255 AND IntCurX < 3 THEN
		IntCurX = IntCurX + 1
		StrTempIP$ = ""
		GOSUB CombineString
		GOSUB WLANSettingsPage
	END IF

	RETURN

'----------------------------------------------------------------------------
CopyDataFrom:
	IF IntCurX = 0 THEN
		StrTempIP$ = StrTempIPA$
	ELSE IF IntCurX = 1 THEN
		StrTempIP$ = StrTempIPB$
	ELSE IF IntCurX = 2 THEN
		StrTempIP$ = StrTempIPC$
	ELSE
		StrTempIP$ = StrTempIPD$
	END IF

	RETURN

'----------------------------------------------------------------------------
CopyDataTo:
	IF IntCurX = 0 THEN
		StrTempIPA$ = StrTempIP$
	ELSE IF IntCurX = 1 THEN
		StrTempIPB$ = StrTempIP$
	ELSE IF IntCurX = 2 THEN
		StrTempIPC$ = StrTempIP$
	ELSE
		StrTempIPD$ = StrTempIP$
	END IF

	RETURN

'----------------------------------------------------------------------------
BackSpace:
	IntLen = LEN (StrNewSets$)

	IF IntLen > 0 THEN
		IF IntSelection <= 4 OR IntSelection = 6 THEN
			IF MID$ (StrNewSets$, IntLen, 1) = "." THEN
				IntCurX = IntCurX -1
				GOSUB CopyDataFrom
			ELSE
				IntLen = LEN (StrTempIP$)
				IF IntLen > 0 THEN
					StrTempIP$ = LEFT$ (StrTempIP$, IntLen-1)
					GOSUB CopyDataTo
				END IF
			END IF
		ELSE IF IntSelection = 7 THEN
			StrTempPort$ = LEFT$ (StrTempPort$, IntLen - 1)
		END IF

	StrNewSets$ = LEFT$ (StrNewSets$, LEN (StrNewSets$)-1)
	END IF

	RETURN

'----------------------------------------------------------------------------
IsPass:
	IF IntSelection <= 4 OR IntSelection = 6 THEN
		IF StrTempIPA$ = "" OR StrTempIPB$ = "" OR StrTempIPC$ = "" OR StrTempIPD$ = "" THEN
			IntResult = -1
		ELSE IF StrNewSets$ = "0.0.0.0" OR StrNewSets$ = "255.255.255.255" THEN
			IntResult = -1
		ELSE
			IntResult = 1
		END IF
	ELSE IF IntSelection = 7 THEN
		IF StrTempPort$ = "" THEN
			IntResult = -3
		ELSE
			IntResult = 1
		END IF
	END IF

	RETURN

'----------------------------------------------------------------------------
SaveData:
	IF IntSelection = 1 THEN
		IP_CFG (2, StrNewSets$)
	ELSE IF IntSelection = 2 THEN
		IP_CFG (1, StrNewSets$)
	ELSE IF IntSelection = 3 THEN
		IP_CFG (3, StrNewSets$)
	ELSE IF IntSelection = 4 THEN
		IP_CFG (4, StrNewSets$)
	ELSE IF IntSelection = 5 THEN
		IP_CFG (6, StrNewSets$)
	ELSE IF IntSelection = 6 THEN
		StrServerIPA$ = StrTempIPA$
		StrServerIPB$ = StrTempIPB$
		StrServerIPC$ = StrTempIPC$
		StrServerIPD$ = StrTempIPD$
	ELSE
		StrServerPort$ = StrTempPort$
	END IF

	RETURN

'----------------------------------------------------------------------------
ShowMessage:
	IF IntResult <> 0 THEN
		CURSOR (0)
		IntShowMessageFlag = 1
		IF IntResult = 1 THEN
			StrMessage1$ = "   Save settings    "
			StrMessage2$ = "   successfully!!   "
		ELSE IF IntResult = -1 OR IntResult = -2 THEN
			StrMessage1$ = "Invalid IP address! "
			StrMessage2$ = "  Range: 0 to 255   "
		ELSE IF IntResult = -3 OR IntResult = -4 THEN
			StrMessage1$ = "Invalid port number!"
			StrMessage2$ = " Range: 1 to 65535  "
		END IF

		SELECT_FONT (1)
		LOCATE 5, 1
		PRINT "********************"
		LOCATE 6, 1
		PRINT StrMessage1$
		LOCATE 7, 1
		PRINT StrMessage2$
		LOCATE 8, 1
		PRINT "********************"

		IF IntResult = 1 THEN
			WAIT (40)
		ELSE
			WHILE IntShowMessageFlag = 1
				StrKeyData$ = ""
				StrKeyData$ = INKEY$
				IF StrKeyData$ <> "" THEN
					IntShowMessageFlag = 0
				END IF
				WAIT (4)
			WEND
			StrKeyData$ = ""
			CURSOR (1)
		END IF
	END IF

	RETURN

'----------------------------------------------------------------------------
GetReaderData:
	StrItem$ = GET_READER_DATA$ (1)
	IF StrItem$ <> "" THEN
		LOCK
		BEEP (1600, 5)

		IntLen = LEN (StrItem$)
		IF IntLen > 13 THEN
			StrItem$ = LEFT$ (StrItem$, 13)
		END IF

		FOR I = 1 TO IntLen
			IntChar = ASC (MID$ (StrItem$, I, 1))
			IF IntChar < 48 OR IntChar > 57 THEN
				IntChar = 0
				StrItem$ = ""
				EXIT
			END IF
		NEXT I

		IF IntChar <> 0 THEN
			GOSUB QueryItem
			GOSUB TakeDataPage
		END IF

		UNLOCK
	END IF

	RETURN

'============================================================================